/**
 * 地球の近似球
 *
 * @author Toshi Tamamori
 */

final public class PerfectSphere extends EarthEllipsoid {
	// 長半径は、この場合球の半径に一致して、扁平率は０である
	// 角度１分が１国際海里:1852メートルという定義から逆算する。
	// 全周＝半径×２π（半周＝半径×π）を逆算して半径を求めることになる。
	// 倍精度数値型での「桁落ち」を防ぐために、整数値で桁あふれしない
	// うちの演算を先におこない、最後に無限小数であるπの演算（ここでは
	// 除算）を最後に行っている。
	
	PerfectSphere() {
		super.AXIS       = 1852.0 * 60 * 180 / Math.PI;
		super.FLATTENING = 0.0;
	}
}