import java.util.logging.*;

/**
 * 当プログラム用のロガー。
 * 内部でjava.util.logging を使っている。
 * （２行で出たり、レベルが日本語で出たりして、相当クセモノですね。）
 * INFO以上のレベルではコンソールにも出てくる。
 *  (これらをより好みに合わせるには・・・もっと勉強しないと・・・)
 * 当クラスはインスタンス化されることは意図していない。
 *
 * @author Toshi Tamamori
 */

final public class GreatArcLogger {
	
	final private static String LOGGER_NAME    = "com.tamamori.GreatArcLogger";
	final private static String LOGFILE_NAME   = "./log/greatarc.log";
	final private static int    LOG_LIMIT      = 1000000;		// bytes?
	final private static int    LOGFILE_COUNT  = 10;
	final private static Level  DEFAULT_LEVEL  = Level.ALL;
	
	// ロガーのインスタンス（への参照）をクラス変数として１つもつ。
	private static Logger   logger;
	
	
	// 別の実装として、static blockにて、loggerの初期化を行う、
	// ということもできるはず。
	// このクラスが最初にロードされるときに、１度だけ呼び出され、
	// 以下のstatic blockが実行されることとなる。
	static {
		System.err.println("GreatArcLogger static block called.");
		
		// loggerの初期化は一度だけにする
		logger = Logger.getLogger(LOGGER_NAME);
		
		try {
			// 出力ファイル名を設定する
			// フォーマットを指定する
			FileHandler     fh = new FileHandler(LOGFILE_NAME, LOG_LIMIT, LOGFILE_COUNT, true); // append
			// SimpleFormatter sf = new SimpleFormatter();
			
			// このままのフォーマットだと、ちと気に入らない★MyFormatterを作らないといけないのかな？
			// see https://blog1.mammb.com/entry/2017/02/24/070608
			
			// 紹介ページを参照して、System.setPropertyで設定してみる(→ちょっとましになる）
			System.setProperty("java.util.logging.SimpleFormatter.format",
			    "%1$tD %1$tT.%1$tL %4$s %2$s %5$s%6$s%n");
			
			SimpleFormatter sf = new SimpleFormatter();
			
			fh.setFormatter(sf);
			logger.addHandler(fh);
			
			// デフォルトのレベルを設定する
			logger.setLevel(DEFAULT_LEVEL);
			
		} catch(Exception e) {
			System.err.println(e.toString());
			
		} 
		
		System.err.println("GreatArcLogger static block terminated.");
	}
	
	// コンストラクタでは何もしないし、privateにしておくので他からは
	// インスタンスを生成することもできない。
	// コンストラクタをprivateにしておく
	private GreatArcLogger() { ; }
	
	/**
	 *  当プログラム用の初期化済のロガーを返す。
	 *
	 * @return ロガーのインスタンス
	 */
	public static Logger getLogger() { return logger; }
	
	/**
	 *  当プログラムのログ出力レベルをランタイム中に変更する
	 *
	 * @param level 新たに設定するログ出力レベル
	 */
	public static synchronized void setLevel(Level level) {
		logger.setLevel(level);
		return;
	}
	
}
