/**
 * 大圏航路計算を実施するインタフェース。
 * 個々の大圏航路計算クラスは、当インタフェースを実装（implement）しなければならない。
 *
 * @author Toshi Tamamori
 */

public interface GreatArcAlg {
	
	/**
	 *  DIRECTの計算
	 *  @param ellipsoid 準拠地球楕円体
	 *  @param source    出発点の緯度・経度
	 *  @param distance  到達点までの距離（単位：メートル）
	 *  @param azimuth   方位角（北が０。時計回りが正。単位：ラジアン）
	 *
	 *  @return 到達点の緯度・経度、および到達点から見た方位角
	 */
	public DirectResult  direct(EarthEllipsoid ellipsoid, LatLng source, double distance, double azimuth);
	
	/**
	 * INVERSE計算
	 * @param ellipsoid 準拠地球楕円体
	 * @param point1    １点目の緯度・経度
	 * @param point2    ２点目の緯度・経度
	 *
	 * @return ２点間の距離、およびそれぞれの地点から見た他方への方位角
	 */
	public InverseResult inverse(EarthEllipsoid ellipsoid, LatLng point1, LatLng point2);
}