/**
 *   それぞれの準拠地球楕円体を表現する抽象クラス。
 *   当クラスを継承した準拠地球楕円体の具象クラスにて、長半径および扁平率を定義する
 *
 * @author Toshi Tamamori
 */

public abstract class  EarthEllipsoid {
	/** 長半径 */
	protected static double AXIS;
	/** 扁平率 */
	protected static double FLATTENING;

	/**
	 * コンストラクタでは何もしません。当クラスを直接インスタンス化することは意図していません。
	 */
	protected EarthEllipsoid() { }

	/**
	 * 長半径を取得する。
	 * @return 長半径（単位：メートル）
	 */
	public double getAxis()       { return AXIS; }
	
	/** 
	 * 扁平率を取得する
	 * @return 扁平率
	 */
	public double getFlattening() { return FLATTENING; }
}
